<?php
/**
 * Plugin Name: Parsgate Forms
 * Plugin URI: https://parsuptime.com/
 * Description: فرم‌ساز سبک به همراه ارسال ایمیل از طریق SMTP و مدیریت گزارش‌ها. قابل استفاده با شورت‌کد در همه صفحات.
 * Version: 1.2.5
 * Requires at least: 6.0
 * Tested up to: 6.9
 * Requires PHP: 8.1
 * Author: پارس آپتایم
 * License: GPLv2 or later
 * Text Domain: parsuptime-form-smtp
 */

if (!defined('ABSPATH')) { exit; }

define('PUFSM_VERSION', '1.2.5');
define('PUFSM_PLUGIN_FILE', __FILE__);
define('PUFSM_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('PUFSM_PLUGIN_URL', plugin_dir_url(__FILE__));

require_once PUFSM_PLUGIN_DIR . 'includes/class-pufsm-db.php';
require_once PUFSM_PLUGIN_DIR . 'includes/class-pufsm-settings.php';
require_once PUFSM_PLUGIN_DIR . 'includes/class-pufsm-mailer.php';
require_once PUFSM_PLUGIN_DIR . 'includes/class-pufsm-forms.php';
require_once PUFSM_PLUGIN_DIR . 'includes/class-pufsm-admin.php';
require_once PUFSM_PLUGIN_DIR . 'includes/class-pufsm-shortcode.php';

register_activation_hook(__FILE__, array('PUFSM_DB', 'activate'));
register_deactivation_hook(__FILE__, array('PUFSM_DB', 'deactivate'));

add_action('plugins_loaded', function () {
    PUFSM_DB::maybe_upgrade();
    PUFSM_Settings::init();
    PUFSM_Forms::init();
    PUFSM_Shortcode::init();
    if (is_admin()) {
        PUFSM_Admin::init();
    }
});
