<?php
if (!defined('ABSPATH')) { exit; }

class PUFSM_Shortcode {

    public static function init() {
        add_shortcode('pu_form', array(__CLASS__, 'render'));
        // Start session only if needed
        add_action('init', array(__CLASS__, 'maybe_start_session'), 1);
    }

    public static function maybe_start_session() {
        if (headers_sent()) { return; }
        if (session_id()) { return; }
        // Session is only used for flash messages; safe fallback is transients.
        // Start session only on frontend to reduce admin side-effects.
        if (!is_admin()) {
            @session_start();
        }
    }

    public static function render($atts) {
        $atts = shortcode_atts(array('id'=>0), $atts, 'pu_form');
        $id = (int) $atts['id'];
        if ($id <= 0) {
            return '<div class="pufsm-note pufsm-error" dir="rtl">شناسه فرم نامعتبر است.</div>';
        }
        return PUFSM_Forms::render_form($id);
    }
}
