<?php
if (!defined('ABSPATH')) { exit; }

class PUFSM_DB {

    const DB_VERSION = '1.2.2';

    public static function activate() {
        self::migrate();
        update_option('pufsm_db_version', self::DB_VERSION, false);
    }

    public static function deactivate() {
        // intentionally left blank (do not delete data)
    }

    public static function maybe_upgrade() {
        $current = get_option('pufsm_db_version', '');
        if ($current !== self::DB_VERSION) {
            self::migrate();
            update_option('pufsm_db_version', self::DB_VERSION, false);
        }
    }

    private static function migrate() {
        global $wpdb;

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';

        $charset_collate = $wpdb->get_charset_collate();

        $forms_table = $wpdb->prefix . 'pufsm_forms';
        $logs_table  = $wpdb->prefix . 'pufsm_logs';

        $sql_forms = "CREATE TABLE $forms_table (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            name VARCHAR(190) NOT NULL,
            recipient VARCHAR(190) NOT NULL,
            subject VARCHAR(190) NOT NULL,
            fields LONGTEXT NOT NULL,
            success_message TEXT NOT NULL,
            is_enabled TINYINT(1) NOT NULL DEFAULT 1,
            created_at DATETIME NOT NULL,
            updated_at DATETIME NOT NULL,
            PRIMARY KEY  (id)
        ) $charset_collate;";

        // Added payload + sender_email for showing messages in admin
        $sql_logs = "CREATE TABLE $logs_table (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            form_id BIGINT(20) UNSIGNED NOT NULL,
            to_email VARCHAR(190) NOT NULL,
            subject VARCHAR(190) NOT NULL,
            status TINYINT(1) NOT NULL DEFAULT 0,
            error_text TEXT NULL,
            sender_email VARCHAR(190) NULL,
            payload LONGTEXT NULL,
            ip VARCHAR(64) NULL,
            user_agent TEXT NULL,
            page_url TEXT NULL,
            created_at DATETIME NOT NULL,
            PRIMARY KEY  (id),
            KEY form_id (form_id),
            KEY status (status),
            KEY created_at (created_at)
        ) $charset_collate;";

        dbDelta($sql_forms);
        dbDelta($sql_logs);

        // Seed a default form if none exists
        $exists = (int) $wpdb->get_var("SELECT COUNT(*) FROM $forms_table");
        if ($exists === 0) {
            $now = current_time('mysql');
            $default_fields = wp_json_encode(array(
                array("name"=>"full_name","label"=>"نام و نام خانوادگی","type"=>"text","required"=>true),
                array("name"=>"email","label"=>"ایمیل","type"=>"email","required"=>true),
                array("name"=>"subject","label"=>"موضوع","type"=>"text","required"=>true),
                array("name"=>"message","label"=>"پیام","type"=>"textarea","required"=>true),
            ), JSON_UNESCAPED_UNICODE);

            $wpdb->insert($forms_table, array(
                'name' => 'فرم تماس (پیش‌فرض)',
                'recipient' => get_option('admin_email'),
                'subject' => 'پیام جدید از فرم تماس: {subject}',
                'fields' => $default_fields,
                'success_message' => 'پیام شما با موفقیت ارسال شد.',
                'is_enabled' => 1,
                'created_at' => $now,
                'updated_at' => $now,
            ), array('%s','%s','%s','%s','%s','%d','%s','%s'));
        }
    }
}
