(function () {
  function closest(el, sel) {
    while (el && el.nodeType === 1) {
      if (el.matches(sel)) return el;
      el = el.parentNode;
    }
    return null;
  }

  function clearNotes(wrapper) {
    var notes = wrapper.querySelectorAll('.pufsm-note, .alert');
    for (var i = 0; i < notes.length; i++) {
      notes[i].parentNode.removeChild(notes[i]);
    }
  }

  function noteClass(type) {
    if (typeof PUFSM !== 'undefined') {
      if (type === 'success' && PUFSM.note_success_class) return PUFSM.note_success_class;
      if (type !== 'success' && PUFSM.note_error_class) return PUFSM.note_error_class;
    }
    return type === 'success' ? 'pufsm-note pufsm-success' : 'pufsm-note pufsm-error';
  }

  function showNote(wrapper, type, message) {
    var note = document.createElement('div');
    note.className = noteClass(type);
    note.innerHTML = message;
    wrapper.insertBefore(note, wrapper.firstChild);
    return note;
  }

  function buildFormData(form) {
    var fd = new FormData(form);
    fd.append('action', 'pufsm_submit_form');
    return fd;
  }

  document.addEventListener('submit', function (e) {
    var form = e.target;
    if (!form || !form.classList || !form.classList.contains('pufsm-form')) return;

    if (typeof PUFSM === 'undefined' || !PUFSM.ajax_url) return;

    e.preventDefault();

    var wrapper = closest(form, '.pufsm-wrap') || form.parentNode;
    clearNotes(wrapper);

    var btn = form.querySelector('button[type="submit"]');
    var oldText = btn ? btn.textContent : '';
    if (btn) {
      btn.disabled = true;
      btn.textContent = 'در حال ارسال...';
    }

    var fd = buildFormData(form);

    fetch(PUFSM.ajax_url, {
      method: 'POST',
      credentials: 'same-origin',
      body: fd
    })
      .then(function (r) {
        return r.json().catch(function () { return { ok: false, message: 'پاسخ نامعتبر از سرور.' }; });
      })
      .then(function (data) {
        if (data && data.ok) {
          wrapper.innerHTML = '<div class="' + noteClass('success') + '">' + (data.message || 'پیام شما با موفقیت ارسال شد.') + '</div>';
        } else {
          showNote(wrapper, 'error', (data && data.message) ? data.message : 'ارسال ناموفق بود.');
          if (btn) { btn.disabled = false; btn.textContent = oldText || 'ارسال'; }
        }
      })
      .catch(function () {
        showNote(wrapper, 'error', 'ارسال ناموفق بود. لطفاً دوباره تلاش کنید.');
        if (btn) { btn.disabled = false; btn.textContent = oldText || 'ارسال'; }
      });
  });
})();